IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL];
GO

GO
--EXEC P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL
/*
Esta procedure roda dentro da P_EST_NF_ENT_DANFE_PROVISORIO_BLOQUEIO_PENDENTE_EXEC_ALL
*/

CREATE PROCEDURE P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL 
WITH ENCRYPTION
AS
    SET NOCOUNT ON;
    DECLARE @CD_CTR INT
    BEGIN TRY
	   DECLARE CProdutoComprador CURSOR FAST_FORWARD FOR
		  SELECT
			 EST_COMPRADOR_GRUPO_APLICAR.CD_CTR
		  FROM
			 EST_COMPRADOR_GRUPO_APLICAR INNER JOIN EST_COMPRADOR_GRUPO_APLICAR_PENDENCIA ON
			 EST_COMPRADOR_GRUPO_APLICAR.CD_CTR = EST_COMPRADOR_GRUPO_APLICAR_PENDENCIA.CD_CTR;

	   OPEN CProdutoComprador;
	   FETCH NEXT FROM CProdutoComprador INTO @CD_CTR;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 EXEC P_EST_COMPRADOR_GRUPO_APLICAR @CD_CTR

			 DELETE FROM EST_COMPRADOR_GRUPO_APLICAR_PENDENCIA WHERE CD_CTR = @CD_CTR

			 FETCH NEXT FROM CProdutoComprador INTO @CD_CTR ;
		  END ;

	   CLOSE CProdutoComprador ;
	   DEALLOCATE CProdutoComprador ;

	END TRY
    BEGIN CATCH

		CLOSE CProdutoComprador ;
		DEALLOCATE CProdutoComprador ;
		DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
		DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
		DECLARE @ErrorState INT = ERROR_STATE();

		INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
			SELECT
				ERROR_NUMBER()	  AS numero
				,@ErrorSeverity	  AS severidade
				,@ErrorState		  AS estado
				,'P_EST_COMPRADOR_GRUPO_APLICAR_EXEC_ALL'	  AS rotina
				,ERROR_LINE()		  AS linha
				,@ErrorMessage	  AS mensagem
				,GETDATE()		  AS dtErro ;

	    RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);

    END CATCH;
    
  --Analisando se nao existe o comprador nao definido
IF NOT EXISTS (SELECT
				*
			   FROM
				EST_COMPRADOR
			   WHERE
				  CD_COMPRADOR=0
				  AND CD_EMP = 1)
BEGIN
	INSERT INTO EST_COMPRADOR
		(CD_EMP,
		CD_COMPRADOR,
		NM_COMPRADOR,
		DD_TEL,
		FONE_RESIDENCIAL,
		FONE_CELULAR,
		FONE_COMERCIAL,
		EMAIL,
		CD_USU,
		DT_CAD)
	select
		1,
		0,
		'NAO DEFINIDO',
		00,
		'',
		'',
		'',
		'',
		1,
		GETDATE()
END

--Se existir produto sem comprador add como nao definido
IF EXISTS (SELECT       
				EST_PROD.CD_PROD
			FROM            
				EST_PROD LEFT OUTER JOIN EST_PROD_COMPRADOR_CPL ON
				EST_PROD.CD_EMP = EST_PROD_COMPRADOR_CPL.CD_EMP AND 
				EST_PROD.CD_PROD = EST_PROD_COMPRADOR_CPL.CD_PROD 
				LEFT OUTER JOIN EST_COMPRADOR_GRUPO_APLICAR_CPL ON
				EST_PROD.CD_EMP = EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_EMP AND 
				EST_PROD.CD_PROD = EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_PROD 
			WHERE
				EST_PROD_COMPRADOR_CPL.CD_PROD IS NULL
				AND EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_PROD IS NULL)
BEGIN
INSERT INTO EST_COMPRADOR_GRUPO_APLICAR
(CD_USU,
DT_CAD,
HISTORICO)
SELECT
1,
GETDATE(),
'CARGA DE PRODUTO COM COMPRADOR NAO DEFINIDO'

INSERT INTO EST_COMPRADOR_GRUPO_APLICAR_CPL
(CD_CTR,
CD_EMP,
CD_PROD,
CD_COMPRADOR)
SELECT       
	IDENT_CURRENT('EST_COMPRADOR_GRUPO_APLICAR'),
	EST_PROD.CD_EMP, 
	EST_PROD.CD_PROD, 
	0
FROM            
	EST_PROD LEFT OUTER JOIN EST_PROD_COMPRADOR_CPL ON
	EST_PROD.CD_EMP = EST_PROD_COMPRADOR_CPL.CD_EMP AND 
	EST_PROD.CD_PROD = EST_PROD_COMPRADOR_CPL.CD_PROD 
	LEFT OUTER JOIN EST_COMPRADOR_GRUPO_APLICAR_CPL ON
	EST_PROD.CD_EMP = EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_EMP AND 
	EST_PROD.CD_PROD = EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_PROD 
WHERE
	EST_PROD_COMPRADOR_CPL.CD_PROD IS NULL
	AND EST_COMPRADOR_GRUPO_APLICAR_CPL.CD_PROD IS NULL
END
